
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons" />
    <title>Questionnaire || Time Square Publishers</title>
</head>
<style>
    @import url('https://fonts.googleapis.com/css?family=Roboto:400,500,700,900&display=swap');
    body {
        padding: 100px 0;
        background: #ECF0F4;
        width: 100%;
        height: 100%;
        font-size: 18px;
        line-height: 1.5;
        font-family: 'Roboto', sans-serif;
        color: #222;
    }
    .container {
        max-width: 1230px;
        width: 100%;
    }
    h1 {
        font-weight: 700;
        font-size: 45px;
        font-family: 'Roboto', sans-serif;
    }
    .header {
        margin-bottom: 80px;
    }
    #description {
        font-size: 24px;
    }
    .form-wrap {
        background: rgba(255,255,255,1);
        width: 100%;
        max-width: 850px;
        padding: 50px;
        margin: 0 auto;
        position: relative;
        border-radius: 10px;
        box-shadow: 0px 0px 40px rgba(0, 0, 0, 0.15);
    }
    .form-wrap:before {
        content: "";
        width: 90%;
        height: calc(100% + 60px);
        left: 0;
        right: 0;
        margin: 0 auto;
        position: absolute;
        top: -30px;
        background: #000;
        z-index: -1;
        opacity: 0.8;
        border-radius: 10px;
        box-shadow: 0px 0px 40px rgba(0, 0, 0, 0.15);
    }
    .form-group {
        margin-bottom: 25px;
    }
    .form-group > label {
        display: block;
        font-size: 18px;
        color: #000;
    }
    .custom-control-label {
        color: #000;
        font-size: 16px;
    }
    .form-control {
        height: 50px;
        background: #ECF0F4;
        border-color: transparent;
        padding: 0 15px;
        font-size: 16px;
        transition: all 0.3s ease-in-out;
    }
    .form-control:focus {
        border-color: #00BCD9;
        box-shadow: 0px 0px 20px rgba(0, 0, 0, .1);
    }
    textarea.form-control {
        height: 160px;
        padding-top: 15px;
        resize: none;
    }
    .btn {
        padding: .657rem .75rem;
        font-size: 18px;
        letter-spacing: 0.050em;
        transition: all 0.3s ease-in-out;
    }
    .btn-primary {
        color: #fff;
        background-color: #00BCD9;
        border-color: #00BCD9;
    }
    .btn-primary:hover {
        color: #00BCD9;
        background-color: #FFFFFF;
        border-color: #00BCD9;
        box-shadow: 0px 0px 20px rgba(0, 0, 0, .1);
    }
    .btn-primary:focus, .btn-primary.focus {
        color: #00BCD9;
        background-color: #FFFFFF;
        border-color: #00BCD9;
        box-shadow: 0px 0px 20px rgba(0, 0, 0, .1);
    }
    .btn-primary:not(:disabled):not(.disabled):active, .btn-primary:not(:disabled):not(.disabled).active, .show > .btn-primary.dropdown-toggle {
        color: #00BCD9;
        background-color: #FFFFFF;
        border-color: #00BCD9;
    }
    .btn-primary:not(:disabled):not(.disabled):active:focus, .btn-primary:not(:disabled):not(.disabled).active:focus, .show > .btn-primary.dropdown-toggle:focus {
        box-shadow: 0px 0px 20px rgba(0, 0, 0, .1);
    }
    .logoimg img {
        width: 200px;
        margin: 0 auto;
        display: table;
        filter: brightness(0.5);
    }
</style>

<body>
    <div class="container">
        <header class="header">
            <h1 id="title" class="text-center">Questionnaire Form || Content Writing</h1>
            <div class="logoimg">
                <img src="https://timesbookpublishing.com/assets/images/logo.png" alt="Brand Logo" class="img-fluid" alt="logo">
            </div>
            <!--<p id="description" class="text-center">Thank you for taking the time to help us improve the platform</p>-->
        </header>
        <div class="form-wrap">
            <form id="survey-form" action="sendmail.php" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="form_id" value="59183">

                <div class="form-group">
                    <label>Name</label>
                    <input type="text" name="company[client_name]" class="form-control" placeholder="" onkeydown="return /^[A-Za-z\s]+$/.test(event.key)" required>
                </div>
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="company[client_email]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>Phone</label>
                    <input type="tel" name="company[client_phone]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>ZIP / Postal Code</label>
                    <input type="text" name="company[client_zip]" pattern="^\d{5}(-\d{4})?$" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>Company Name</label>
                    <input type="text" name="company[company_name]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>What is the origin, history, timeline, chronology, achievements, and future plans of your company?</label>
                    <input type="text" name="company[company_history]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>What is the industry that your business caters to?</label>
                    <input type="text" name="company[company_industry]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>What is the reason behind what you do; passion? Heritage? Necessity? Passion?</label>
                    <textarea name="company[company_reason]" class="form-control" placeholder="" rows="5" required></textarea>
                </div>
                <div class="form-group">
                    <label>Please list all products and services you provide.</label>
                    <input type="text" name="company[company_products_services]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>Short description of your business in your own words.</label>
                    <input type="text" name="company[company_description]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>List 10 or more keywords that best describe your business.</label>
                    <input type="text" name="company[company_keywords]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>List three or more of your top competitors.</label>
                    <textarea name="company[company_competitors]" class="form-control" placeholder="" rows="5" required></textarea>
                </div>
                <div class="form-group">
                    <label>The Headers/Tabs (Pages) for which you want us to write the content for you.</label>
                    <input type="text" name="company[company_pages]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>In your words, what are the core strengths of your business?</label>
                    <input type="text" name="company[company_strengths]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>What do you think your customers accomplish by using your product/services?</label>
                    <textarea name="company[company_customers_accomplish]" class="form-control" placeholder="" rows="5" required></textarea>
                </div>
                <div class="form-group">
                    <label>What sets your company apart from your competitors?</label>
                    <input type="text" name="company[company_differentiation]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>What is your mission statement?</label>
                    <input type="text" name="company[company_mission]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>An address, contact number or detail you would want to add so customers can reach you other than the website.</label>
                    <input type="text" name="company[company_contact]" class="form-control" placeholder="" required>
                </div>
                <div class="form-group">
                    <label>Do you have any existing/preferred taglines and/or slogans that you would like us to use?</label>
                    <input type="text" name="company[company_tagline]" class="form-control" placeholder="" required>
                </div>
                
                <div class="form-group">
                    <label>Upload Any Supporting Documents (Optional)</label>
                   <input class="form-control" type="file" name="image[]" multiple value="">
                </div>
                <div class="form-group">
                    <button type="submit" name="submit" class="btn btn-primary btn-block">Submit</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
