<!DOCTYPE html>
<html lang="en">

<head>

    <?php
    session_start();
    // Check if msclkid is present in the URL and store it in the session
    if (isset($_GET['msclkid'])) {
        $_SESSION['msclkid'] = $_GET['msclkid'];
    }
    // Check if gclid is present in the URL and store it in the session
    if (isset($_GET['gclid'])) {
        $_SESSION['gclid'] = $_GET['gclid'];
    }
    ?>

    <title>Premium Book Publishing Services | <?php echo $brand_name ?></title>
    <meta name="description"
        content="Are you looking for <?php echo $brand_name ?> for hire? <?php echo $brand_name ?> offering ghostwriting services from the best ghostwriting agency &amp; company who can turn your idea into a book.">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="shortcut icon" href="../assets/images/favicon.png"
        type="image/x-icon">
    <link rel="stylesheet" href="css/css-css-all.css">
    <link rel="stylesheet" href="../swiper%408.4.7/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="css/css-css-style.css">
    <link rel="stylesheet" type="text/css" href="css/css-css-style-web.css">
    <link rel="stylesheet" type="text/css"
        href="css/css-css-responsive.css">
    <style>
        h2::before,
        h2::after {
            background: transparent !important;

            ul.list-scroll.height220.list-2 {
                padding-left: 20px;
                line-height: 25px;
                height: 350px;
                overflow-y: scroll;
            }
        }

        div#package-yearly {
            position: relative;
            width: 90%;
            margin: auto;
            min-width: 90% !important;
            border: 1px solid #ddd;
            padding: 20px !important;
            height: 550px;
        }

        ul.list-scroll.height220.list-2 {
            padding-left: 5px;
            line-height: 25px;
            height: 350px;
            overflow-y: scroll;
        }

        div#package-yearly {
            border-radius: 8px;
            background-color: #fff;
            padding: 30px;
            -webkit-transition: 300ms all cubic-bezier(.4, 0, .2, 1);
            transition: 300ms all cubic-bezier(.4, 0, .2, 1);
            margin-top: 24px;
            box-shadow: 0 8px 60px 0 rgba(103, 151, 255, .11), 0 12px 90px 0 rgba(103, 151, 255, .11);
        }

        .pkg-box {
            margin-bottom: 40px;
        }

        .list-2 li:before {
            content: "\f00c";
            font-size: 12px;
            margin-right: 10px;
            font-family: FontAwesome;
            left: -19px;
            position: absolute;
            color: #FEB843 !important;
            top: 2px;
        }

        .list-2 li {
            position: relative;
            margin-left: 22px;
        }

        ul.list-scroll.list-2 h6 {
            margin-top: 10px;
        }

        ul.list-scroll.height220.list-2 span {
            display: block;
            margin-left: 20px;
        }

        form.leadForm.form-get-quote textarea {
            height: 40px;
        }
    </style>

    <?php include '../includes/style.php' ?>
</head>

<body>

    <header>
        <div class="container">
            <div class="row  align-items-center">
                <div class="col-md-3 col-sm-3">
                    <a href="index.php.html" class="logo">
                        <img src="../assets/images/logo.png" alt>
                    </a>
                </div>
                <div class="col-md-9 col-sm-9">
                    <nav class="navbar-expand-md main-menu">
                        <ul class="menu">
                            <li class="phone">
                                <i class="fas fa-phone-alt"
                                    aria-hidden="true"></i>
                                <a href="tel:<?php echo $phone ?>"><?php echo $phone ?> </a>
                            </li>
                            <li class="msg">
                                <a href="javascript:;" data-fancybox
                                    data-src="#popupform"
                                    class="btn btn-dark various">
                                    Get Started
                                </a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </header>

    <section class="mainBan">
        <div class="top_circle_wrapper">
            <img src="images/images-circle-dash.png">
        </div>
        <div class="container-fluid" style="position: relative;z-index: 1;">
            <div class="row align-items-center justify-content-between">
                <div class="col-md-7">
                    <h2 class="banner_title">Publish Your Book Over
                        <strong>Renowned Platforms</strong> through
                        our <strong>Book Publishing</strong> Services
                    </h2>
                    <p>We have a track record of delivering thousands of
                        successful publications – meticulously written,
                        edited, designed and published. Many of the
                        published works we have done for our clients
                        have created a buzz in the literary sphere and
                        ranked among the best sellers.
                    </p>

                    <div class="btn-block">
                        <a href="javascript:;" class="btn btn-light chat">
                            Live Chat
                        </a>
                        <a href="javascript:;" data-fancybox
                            data-src="#popupform"
                            class="btn btn-dark chat various">
                            Get Started
                        </a>
                    </div>
                </div>
                <div class="col-md-5 signupform">
                    <style>
                        .signupform .banner-inner-form {
                            padding: 22px 0 0 0;
                            background-size: cover;
                            border-radius: 10px;
                            width: 100%;
                            z-index: 5;
                            background: #bd7739;
                            margin-bottom: 20px;

                        }

                        .signupform .avail-header h2 {
                            padding: 0px 10px;
                            color: #feb843;
                            font-size: 36px;
                            font-weight: 600;
                            line-height: 10px;

                        }

                        .avail-header p {
                            padding: 0px 10px;
                            font-size: 26px;
                            color: #fff;
                            text-transform: uppercase;
                            font-weight: 500;
                        }

                        .timer-header h3 {
                            padding: 0px 10px;
                            font-size: 26px;
                            color: #fff;
                            text-transform: uppercase;
                            font-weight: 500;
                        }

                        .signupform form.leadForm {
                            padding: 20px 20px;
                            z-index: 12;
                            position: relative;
                        }

                        .signupform button#signupBtn {
                            background: #feb843;
                            border: 0;
                            color: #fff;
                            font-weight: 600;
                            font-size: 26px;
                            width: 100%;
                            padding: 10px 0;
                            border-radius: 7px;
                        }
                    </style>

                    <div class="whychoose-right">
                        <div class=" banner-inner-form">
                            <div class="timer-header">
                                <h3>Sign up Now</h3>

                            </div>
                            <div class="avail-header">
                                <h2>Get Started with Our Services</h2>
                                <p>Contact us to learn more</p>
                            </div>
                            <div>
                                <form action="/sendmail.php" class="leadForm form-get-quote"
                                    method="post">

                                    <!--hidden fields-->
                                    <input type="hidden" name="lead_source" value="<?= $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI']; ?>">
                                    <input type="hidden" name="brand" value="<?= $_SERVER['SERVER_NAME']; ?>">
                                    <input type="hidden" name="ip" value="<?php echo $_SERVER["REMOTE_ADDR"]; ?>">
                                    <!-- extra  -->
                                    <input type="text" name="msclkid" hidden value="<?php echo isset($_SESSION['msclkid']) ? $_SESSION['msclkid'] : ''; ?>">
                                    <input type="text" name="gclid" hidden value="<?php echo isset($_SESSION['gclid']) ? $_SESSION['gclid'] : ''; ?>">
                                    <!--hidden fields-->

                                    <div class="row">
                                        <div class="col-12 col-md-12">
                                            <div class="form-group">

                                                <input type="text"
                                                    class="form-control"
                                                    placeholder="Full Name *"
                                                    required
                                                    name="full_name">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-12">
                                            <div class="form-group">

                                                <input type="text"
                                                    class="form-control"
                                                    placeholder="Email *"
                                                    required
                                                    name="email">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-12">
                                            <div class="form-group">

                                                <input type="text"
                                                    class="form-control phoneNum"
                                                    placeholder="Phone Number *"
                                                    required
                                                    name="phone">
                                            </div>
                                            <div class="form-group">

                                                <textarea
                                                    class="form-control"
                                                    placeholder="Message *"
                                                    required
                                                    name="message"
                                                    rows="5"></textarea>

                                            </div>
                                        </div>

                                        <!--<div class="col-12 col-md-12">-->
                                        <!--    <div class="form-group">-->

                                        <!--        <input type="text" class="form-control" placeholder="Coupen Code *" maxlength="10" required-->
                                        <!--            name="quote[coupen_cpden]">-->
                                        <!--    </div>-->
                                        <!--</div>-->
                                        <div class="col-12 col-md-12">

                                            <?php include '../includes/checkbox.php' ?>

                                            <button class="banner_form_btn"
                                                type="submit"
                                                id="signupBtn">RESERVE THE
                                                OFFER</button>
                                            <div
                                                class="error mt-3 alert alert-danger text-left mb-0"
                                                style="display: none"></div>
                                            <div
                                                class="success mt-3 alert alert-success text-left mb-0"
                                                style="display: none"></div>
                                            <div class="loader"
                                                style="display: none">
                                                <img alt="loader"
                                                    src="loader.gif">
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <div class="bottom_circle_wrapper">
            <img src="images/images-circle-dash.png">
        </div>
    </section>
    <!--<section class="our-allow">-->
    <!--    <div class="container" data-aos="fade-up" data-aos-duration="1000">-->
    <!--        <div class="row">-->
    <!--            <div class="col-md-3">-->
    <!--                <h2>We Publish <br>-->
    <!--                    Your Book <br>-->
    <!--                    On All Leading <br>-->
    <!--                    Platforms!-->
    <!--                </h2>-->
    <!--            </div>-->
    <!--            <div class="col-md-9">-->
    <!--                <img src="images/brandz.jpg" alt>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</section>-->
    <section class="our-publishing">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <h2 class="text-center zila">
                Skip the hassle. Start your publishing journey today
            </h2>
            <div class="row">
                <div class="col-md-7">
                    <div class="txt">
                        <ul>
                            <li><img
                                    src="images/images-images-our-pub-ul.png"
                                    alt> A stunning premium cover to get
                                your book noticed</li>
                            <li><img
                                    src="images/images-images-our-pub-ul.png"
                                    alt> EBook conversion to any format
                                including
                                HTML.</li>
                            <li><img
                                    src="images/images-images-our-pub-ul.png"
                                    alt> Keep all revenues from your eBooks
                                with
                                our suggested price.</li>
                            <li><img
                                    src="images/images-images-our-pub-ul.png"
                                    alt> The final step to get your eBook
                                selling
                                is publishing.</li>
                            <li><img
                                    src="images/images-images-our-pub-ul.png"
                                    alt> Marketplace integration by having
                                accounts on all platforms.</li>
                            <li><img
                                    src="images/images-images-our-pub-ul.png"
                                    alt> Free setup for those new to the
                                ghostwriting industry.</li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-5">
                    <p>The publishing industry has evolved considerably in
                        the last decade to deal with digital
                        disruption, piracy, changing reading habits, the
                        rise of audiobooks, extreme competition,
                        production problems, and excessive promotion. It is
                        extremely hard to get a traditional
                        publisher to even read your manuscript let alone
                        offer you a publishing contract. Traditional
                        publishers are generally bombarded with hundreds of
                        manuscripts from tons of writers and agents.
                        That is why choosing
                        <?php echo $brand_name ?> to get your book published is the
                        way to go for new and
                        established writers!
                    </p>
                    <div class="btn-block">
                        <a href="javascript:;" class="btn btn-light chat">
                            Live Chat
                        </a>
                        <a href="javascript:;" data-fancybox
                            data-src="#popupform"
                            class="btn btn-dark chat various">
                            Get Started
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="our-author">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <div class="row">
                <div class="col-md-7">
                    <h2 class="zila">
                        Publish Your Book with Us <br> Enjoy Full
                        Distribution <br>Benefits
                    </h2>
                    <p>No need to stress about editing, formatting, or cover
                        design — we’ve got it all covered in one complete
                        publishing package</p>
                    <!-- <div class="seal">
                        <img src="images/images-images-form-seal.png" alt>
                    </div> -->
                    <div class="btn-block">
                        <a href="javascript:;" class="btn btn-light chat">
                            Live Chat
                        </a>
                        <a href="javascript:;" data-fancybox
                            data-src="#popupform"
                            class="btn btn-dark chat various">
                            Get Started
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="our-process">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <h2 class="text-center zila">
                We Turn Passion Into Pages — See How Our Process Works
            </h2>
            <h3>
                <?php echo $brand_name ?> book publishing process is a simple
                six-step process that has been
                streamlined over
                the years to make the entire experience smooth, functional,
                and easy to understand for our clients.
                Check out our publishing process down below.
            </h3>
            <div class="owl-process owl-carousel owl-theme">
                <div class="item">
                    <div class="process">
                        <h5>step 01</h5>
                        <h4>Connect <br> with Us</h4>
                        <p>The first step of the process is for you to leave
                            us a message online with details of your
                            project. We will then get back to you and answer
                            any questions you may have.</p>
                    </div>
                </div>
                <div class="item">
                    <div class="process">
                        <h5>step 02</h5>
                        <h4>Draft <br> Review</h4>
                        <p>The second step is when you submit to us your
                            book’s final and complete draft and our experts
                            will review it to see how they can market it
                            after publishing.</p>
                    </div>
                </div>
                <div class="item">
                    <div class="process">
                        <h5>step 03</h5>
                        <h4>Editing, Proofreading, <br> &amp;
                            Formatting</h4>
                        <p>The third step is when your book’s final draft is
                            handed over to our team of editors and
                            formatters wherein they check for any errors and
                            format the book to industry standard.</p>
                    </div>
                </div>
                <div class="item">
                    <div class="process">
                        <h5>step 04</h5>
                        <h4>Book Cover Design</h4>
                        <p>The fourth step is when our creative team of
                            designers get to work on designing your book’s
                            front and back covers to make it worthy of being
                            picked up from a shelf.</p>
                    </div>
                </div>
                <div class="item">
                    <div class="process">
                        <h5>step 05</h5>
                        <h4>Book <br> Publishing</h4>
                        <p>The fifth step is when we finally publish your
                            book! We’ll publish your book in print,
                            digitally (on all platforms), and even offer
                            print-on-demand services.</p>
                    </div>
                </div>
                <div class="item">
                    <div class="process">
                        <h5>step 06</h5>
                        <h4>Profit!</h4>
                        <p>The sixth step is quite simple: you sit back and
                            enjoy the revenue generated by your
                            published book after we’re done distributing and
                            promoting it to maximize sales.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="mainBan">

        <div class="container-fluid" style="position: relative;z-index: 1;">
            <h2 class="text-center zila">
                OUR PACKAGES
            </h2>
            <div class="row align-items-center justify-content-between">

                <div class="col-md-4">

                    <div class="pkg-box">
                        <div id="package-yearly"
                            class="package column card accent-purple centered">
                            <h2 class="card-title">Starter Author Package
                            </h2>

                            <ul class="list-scroll height220 list-2">
                                <li>Premium Proofreading, Formatting &
                                    Editing.</li>
                                <li> Premium Publishing</li>
                                <li>Author Central Account Setup</li>
                                <li> Optimization of Author Central
                                    Accounts</li>
                                <li>Premium Publication & Formatting:</li>
                                <li>Custom Interior Design and
                                    Formatting</li>
                                <li>Text Formatting</li>
                                <li> Industry-Standard Book Design</li>
                                <li>Front Matter, Chapter Titles,
                                    Narrative</li>
                                <li>Table of Contents</li>
                                <li>Final File for Paperback</li>
                                <li>Standard Services Plus.</li>
                                <li>Formatting Front and Back Matter</li>
                                <li> Design Review and Revision</li>
                                <li>Final PDF File Set Up to Printer
                                    Specifications</li>
                                <li>Final EPUB and Kindle File</li>
                                <h6>Publication on:</h6>
                                <span>1- Amazon Kindle</span>
                                <span>2- Barnes & Noble</span>
                                <span>3- Baker & Taylor</span>
                            </ul>

                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="pkg-box">
                        <div id="package-yearly"
                            class="package column card accent-purple centered">
                            <h2 class="card-title">Intermediate Author
                                Package </h2>

                            <ul class="list-scroll height220 list-2">
                                <li>Premium Proofreading, Formatting &
                                    Editing.</li>
                                <li> Premium Publishing</li>
                                <li>Author Central Account Setup</li>
                                <li> Optimization of Author Central
                                    Accounts</li>
                                <li>Premium Publication & Formatting:</li>
                                <li>Custom Interior Design and
                                    Formatting</li>
                                <li>Text Formatting</li>
                                <li> Industry-Standard Book Design</li>
                                <li>Front Matter, Chapter Titles,
                                    Narrative</li>
                                <li>Table of Contents</li>
                                <li>Final File for Paperback</li>
                                <li>Standard Services Plus.</li>
                                <li>Formatting Front and Back Matter</li>
                                <li> Design Review and Revision</li>
                                <li>Final PDF File Set Up to Printer
                                    Specifications</li>
                                <li>Final EPUB and Kindle File</li>
                                <h6>Publication on:</h6>
                                <span>1- Amazon Kindle</span>
                                <span>2- Barnes & Noble</span>
                                <span>3- Baker & Taylor</span>
                                <span>4-Apple iBook</span>
                                <span>5- Google Books</span>
                                <span>6- Ingram Spark
                                </span>
                            </ul>

                        </div>
                    </div>
                </div>

                <div class="col-md-4">

                    <div class="pkg-box">
                        <div id="package-yearly"
                            class="package column card accent-purple centered">
                            <h2 class="card-title">Premium Author Package
                                (Best-Seller)
                            </h2>

                            <ul class="list-scroll height220 list-2">
                                <h6>Editing & Design</h6>
                                <li>Professional proofreading, editing, and
                                    formatting</li>
                                <li> Custom interior layout and
                                    industry-standard book design</li>
                                <li>Print-ready PDF, EPUB, and Kindle
                                    files</li>
                                <h6>Publishing & Setup
                                </h6>
                                <li> Publishing on major global
                                    platforms</li>
                                <li>Author Central account setup and
                                    optimization</li>
                                <h6>Marketing & SEO</h6>
                                <li>Pre-launch, launch, and post-launch
                                    campaigns</li>
                                <li>SEO optimization (Amazon, IngramSpark,
                                    etc.)</li>
                                <li> Backlink strategy & 3-month SEO
                                    maintenance</li>
                                <h6>Global Distribution:</h6>

                                <span>1- Amazon Kindle</span>
                                <span>2- Barnes & Noble</span>
                                <span>3- Baker & Taylor</span>
                                <span>4- Apple iBook</span>
                                <span>5- Google Books</span>
                                <span>6- Ingram Spark</span>
                                <span>7- CreateSpace</span>
                                <span>8- Tolino/Thalia</span>
                                <span>9- Vivlio</span>
                                <span>10- Bol.de</span>
                                <span>11- Blurb</span>
                                <span>12- Kobo</span>
                                <span>13- Scribd</span>
                                <span>14- Books-A-Million</span>
                                <span>15- Audible</span>

                                <h6>Global availability:</h6>
                                <span>Publication Consultancy (includes
                                    distribution proposal to nationwide
                                    bookstores and public libraries which
                                    includes 850 Physical book stores and
                                    public libraries to have your book
                                    distributed around the states)</span>

                            </ul>

                        </div>
                    </div>

                </div>

            </div>
        </div>

    </section>

    <section class="our-amazon">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <h2 class="zila">Getting a Book Published Has Never Been This
                Easy</h2>
            <h3>Publishing Made Easy and Accessible</h3>
            <div class="btn-block">
                <a href="javascript:;" class="btn btn-light chat">
                    Live Chat
                </a>
                <a href="javascript:;" data-fancybox data-src="#popupform"
                    class="btn btn-dark chat various">
                    Get Started
                </a>
            </div>
            <a class="tel" href="tel:<?php echo $phone ?>">
                <img src="images/images-images-amazon-tel.png" alt>
                <?php echo $phone ?> </a>
        </div>
    </section>
    <section class="our-testimonial">
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <h2 class="zila">
                REVIEWS FROM OUR CLIENTS <br>
                See what our clients have to say about us!
            </h2>
            <div class="owl-testimonial owl-carousel owl-theme">
                <div class="item">
                    <div class="info-testi">
                        <p>“I’ve had several of my books ghostwritten,
                            edited, formatted, designed, and published
                            through
                            <?php echo $brand_name ?>! They’ve taken my dreams of
                            becoming a writer by profession and
                            made it a reality and now all I have to do is
                            come up with new book ideas.”
                        </p>
                        <h4>Arnold Moss</h4>
                    </div>
                </div>
                <div class="item">
                    <div class="info-testi">
                        <p>“As a writer who writes a lot of books every
                            month, I never have the time to edit my book let
                            alone go after publishing agencies to notice my
                            manuscript.
                            <?php echo $brand_name ?> has taken a
                            load off my back with their editing and
                            publishing services!”
                        </p>
                        <h4>Lindsey Page</h4>
                    </div>
                </div>
                <div class="item">
                    <div class="info-testi">
                        <p>“It’s not easy keeping up with readers’ demands
                            for sequels to a book series you start.
                            That’s why I outsource some of my writing
                            projects to
                            <?php echo $brand_name ?>! Their team is
                            excellent with both the writing and the editing
                            and they publish my work for me too!”
                        </p>
                        <h4>Gabriel Watts</h4>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container" data-aos="fade-up" data-aos-duration="1000">
            <div class="row">
                <div class="col-md-6">
                    <h2>
                        Contact us today to <br>
                        receive a free <br>
                        consultation
                    </h2>
                    <h3>Speak with our consultant now.</h3>
                    <p>Feel free to reach out to us today to receive a free
                        consultation from our experts. We will
                        answer all your questions and help you get started
                        on your journey to become a fully published
                        author! We’re available 24/7.</p>
                    <a href="javascript:;" class="btn speak-btn chat">Live
                        Chat</a>
                    <a class="tel" href="<?php echo $phone ?>">
                        <img src="images/images-images-amazon-tel.png" alt>
                        <?php echo $phone ?> </a>
                </div>
                <div class="col-md-6">
                    <div class="info-contact">
                        <h4>
                            Get in touch
                        </h4>
                        <p>Use the form below to contact us regarding your
                            ghostwriting concerns. Please be as detailed
                            as possible. You may also email or call us for
                            more information.</p>
                        <!-- <div class="seal">
                            <img src="images/images-images-form-seal.png"
                                alt>
                        </div> -->
                        <div class="info-form">
                            <form action="/sendmail.php" class="form-get-quote" method="POST">

                                <!--hidden fields-->
                                <input type="hidden" name="lead_source" value="<?= $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI']; ?>">
                                <input type="hidden" name="brand" value="<?= $_SERVER['SERVER_NAME']; ?>">
                                <input type="hidden" name="ip" value="<?php echo $_SERVER["REMOTE_ADDR"]; ?>">
                                <!-- extra  -->
                                <input type="text" name="msclkid" hidden value="<?php echo isset($_SESSION['msclkid']) ? $_SESSION['msclkid'] : ''; ?>">
                                <input type="text" name="gclid" hidden value="<?php echo isset($_SESSION['gclid']) ? $_SESSION['gclid'] : ''; ?>">
                                <!--hidden fields-->
                                <div class="row">
                                    <div class="col-md-7">
                                        <input type="text"
                                            name="full_name"
                                            placeholder="Name"
                                            class="required form-control"
                                            required aria-required="true">
                                        <input type="text"
                                            class="required form-control ftpn phoneNum"
                                            required name="phone"
                                            placeholder="Your Phone"
                                            aria-required="true">
                                        <input type="email"
                                            name="email"
                                            placeholder="Email Address"
                                            class="required email form-control"
                                            required aria-required="true">
                                    </div>
                                    <div class="col-md-5">
                                        <textarea name="message"
                                            class="required form-control"
                                            placeholder="To help us understand better, enter a brief description about your project."
                                            aria-required="true"></textarea>
                                    </div>
                                </div>


                                <?php include '../includes/checkbox.php' ?>

                                <input type="submit" name="submit"
                                    class="btn btn-red "
                                    value="Submit Your Request">

                                <!-- Button fields -->
                                <div
                                    class="error mt-3 alert alert-danger text-left mb-0"
                                    style="display: none"></div>
                                <div
                                    class="success mt-3 alert alert-success text-left mb-0"
                                    style="display: none">
                                </div>


                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <section class="copy">
        <div class="container">
            <div class="row">
                <div class="col-md-5">
                    <p> Copyright ©
                        2025 -
                        <?php echo $brand_name ?>. All Rights Reserved
                    </p>
                </div>
                <div class="col-md-7">
                    <ul class="term">
                        <li><a href="/opt-out-option.php">Opt Out Option</a></li>
                        <li><a href="/refund-policy.php">Refund Policy</a></li>
                        <li><a href="/terms-and-conditions.php">Terms &amp; Condition</a></li>
                        <li><a href="/privacy-policy.php">Privacy Policy</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <div style="display: none;" class="popupform" id="popupform">
        <div class="modal-body">
            <div class="popup-content">
                <h2>Signup Now for an Exclusive Discount</h2>

                <form action="../sendmail.php" class="form-get-quote" method="POST">

                    <!--hidden fields-->
                    <input type="hidden" name="lead_source" value="<?= $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI']; ?>">
                    <input type="hidden" name="brand" value="<?= $_SERVER['SERVER_NAME']; ?>">
                    <input type="hidden" name="ip" value="<?php echo $_SERVER["REMOTE_ADDR"]; ?>">
                    <!-- extra  -->
                    <input type="text" name="msclkid" hidden value="<?php echo isset($_SESSION['msclkid']) ? $_SESSION['msclkid'] : ''; ?>">
                    <input type="text" name="gclid" hidden value="<?php echo isset($_SESSION['gclid']) ? $_SESSION['gclid'] : ''; ?>">
                    <!--hidden fields-->
                    <div class="row">
                        <div class="col-md-12">
                            <input type="text" class="required form-control"
                                required name="full_name"
                                placeholder="Your Name">
                            <input type="email"
                                class="required form-control" required
                                name="email"
                                placeholder="Your Email">
                            <input type="text"
                                class="required form-control ftpn phoneNum"
                                required name="phone"
                                placeholder="Your Phone">
                            <textarea autocomplete="nope"
                                name="message"
                                class="required form-control" required
                                placeholder="To help us understand better, enter a brief description about your project."></textarea>
                        </div>

                        <div class="col-md-12">
                            <?php include '../includes/checkbox.php' ?>
                        </div>

                        <div class="col-md-12">

                            <input type="submit" class="btn btn-black"
                                name="send_data" value="Submit Now">

                            <!-- Button fields -->

                            <div
                                class="error mt-3 alert alert-danger text-left mb-0"
                                style="display: none"></div>
                            <div
                                class="success mt-3 alert alert-success text-left mb-0"
                                style="display: none"></div>


                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="cta-phn-mobile">
        <a class="call-func" href="tel:<?php  echo $phone;?>"><span><img class="lazy" src="/assets/images/tele-icon.webp"></span>Call Now</a>
    </div>
    
    <style>
        .cta-phn-mobile{background:#000;text-align:center;color:#fff!important;padding:5px;position:fixed;bottom:0!important;z-index:999;width:100%;display:none}.cta-phn-mobile a{color:#fff!important;text-decoration:none;display:flex;justify-content:center;align-items:center;}@media (max-width:767px) and (min-width:320px){.cta-phn-mobile{display:block!important}body{overflow-x:hidden}footer {padding-bottom: 30px;}}
    </style>
    <script type="text/javascript" src="js/9570-js-js-libs.js"></script>

    <script src="js/swiper%408-swiper-bundle.min.js"></script>
    <script src="js/743fc22ee9.js"></script>
    <script src="js/js-jquery.validate.min.js"></script>
    <script type="text/javascript" src="js/97-js-js-functions.js"></script>
    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
        $(document).ready(function() {
            $('.chat').each(function() {
                $(this).addClass('ck_open_chat').removeClass('chat');
            });
        });
    </script>

    <script>
        var swiper = new Swiper(".banner-book-slider", {
            effect: "cards",
            grabCursor: true,
            loop: false,
            autoplay: {
                delay: 1000,
            },
            speed: 1200,
        });

        //owlcarousel
        $('.owl-testimonial').owlCarousel({
            loop: true,
            nav: true,
            dots: false,
            responsiveClass: true,
            autoplay: true,
            autoplayTimeout: 8000,
            autoplaySpeed: 800,
            margin: 10,
            responsive: {
                0: {
                    items: 3,
                },
                600: {
                    items: 3,
                },
                1000: {
                    items: 2,
                },
                360: {
                    items: 1
                }
            }
        });
        $('.owl-process').owlCarousel({
            loop: true,
            nav: false,
            dots: false,
            responsiveClass: true,
            autoplay: true,
            autoplayTimeout: 8000,
            margin: 30,
            autoplaySpeed: 800,
            responsive: {
                0: {
                    items: 4,
                },
                600: {
                    items: 4,
                },
                1000: {
                    items: 2,
                },
                360: {
                    items: 1,
                }
            }
        });
    </script>

    <script>
        $(".phoneNum").inputmask({
            "mask": "+9 (999) 999-9999"
        }).on("input", function() {
            var minLength = 11; // minimum length of the formatted phone number, including the country code
            var phoneNumber = $(this).val().replace(/\D/g, ''); // remove non-digit characters from the input value
            if (phoneNumber.length < minLength) {
                this.setCustomValidity("Phone number must have a minimum length of " + minLength + " digits");
            } else {
                this.setCustomValidity("");
            }
        });
    </script>

    <?php echo $chat ?>


</body>

</html>